// Adapted from boolfind example program: https://github.com/DOMjudge/domjudge/tree/main/example_problems/boolfind/output_validators/boolfind_run

#include <utility>
#include <string>
#include <sstream>
#include <string>
#include <cassert>
#include <cstring>
#include <cmath>
#include <unistd.h>
#include <vector>
#include <stdio.h>
#include <stdlib.h>
#include "runjury_murky_maze.h"

using namespace std;

void check_case() {
	int n, m;
	assert(judge_in >> n >> m);
	int cnt = 0;
	char board[500][500];
	int y, x;
	for (int i = 0; i < 2*n + 1; i++) {
		for (int j = 0; j < 2*m + 1; j++) {
			judge_in >> board[i][j];
			if (board[i][j] == 's') {
				y = i;
				x = j;
			} else if (board[i][j] == '.') {
				cnt += 1;
			}
		}
	}

	int nquery = 0;

	while (true) {
		nquery++;
		if (nquery > 2*cnt) {
			wrong_answer("Too many attemtps");
		}
		string text = "";
		if (board[y + 1][x] != '#') {
			text += "S ";
		}
		if (board[y][x + 1] != '#') {
			text += "E ";
		}
		if (board[y - 1][x] != '#') {
			text += "N ";
		}
		if (board[y][x - 1] != '#') {
			text += "W ";
		}
		text.pop_back();
		cout << text << endl;

		string dir;
		cin >> dir;
		if (dir == "N") {
			if (board[y - 1][x] == '#') wrong_answer("Runs into a wall.");
			y--;
		} else if (dir == "S") {
			if (board[y + 1][x] == '#') wrong_answer("Runs into a wall.");
			y++;
		} else if (dir == "W") {
			if (board[y][x - 1] == '#') wrong_answer("Runs into a wall.");
			x--;
		} else if (dir == "E") {
			if (board[y][x + 1] == '#') wrong_answer("Runs into a wall.");
			x++;
		} else {
			wrong_answer("This is not a valid direction.");
		}

		if (y == 0) {
			cout << "Finally, freedom!" << endl;
			break;
		}
	}
/*
	const int magic_number = 99371;

	int f[magic_number] = {0};
	int original[magic_number];
	for (int i = 0; i < magic_number; i++) {
		original[i] = -1;
	}

	for (int i = 0; i < k; i++) {
		int x, y;
		judge_in >> x >> y;
		f[x % magic_number] = y;
		original[x % magic_number] = x;
	}

	int nquery = 0;
	while (true) {
		nquery++;
		if (nquery > size + 3) {
			wrong_answer("Too many attemtps");
		}
		int value;
		if (!(author_out >> value)) {
			wrong_answer("Cannot parse set in %dth query.\n", nquery);
		}
		if (original[value % magic_number] != value) {
			wrong_answer("Non-valid set formatting in %dth query: %d ; %d", nquery, value, original[value % magic_number]);
		}
		cout << f[value % magic_number] << endl;
		if (f[value % magic_number] == value) {
			break;
		}
		
	}*/
}

int main(int argc, char **argv) {
	init_io(argc, argv);

	check_case();

	// Check for trailing output.
	string trash;
	if (author_out >> trash) {
		wrong_answer("Trailing output: '%s'\n", trash.c_str());
	}

	// Yay!
	accept();
}
